/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.effects;

import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;

import intrinsic.flash.filters.*;

public class GlowEffect extends Effect {
	
	public GlowEffect() {
		super();
	}
	
	void createHandle() {
		GlowFilter filter = new GlowFilter();
		if (filter == null) SWT.error(SWT.ERROR_NO_HANDLES);
		object = filter;
	}
	
	public void setColor(Color color) {
		checkEffect();
		if (color == null) SWT.error(SWT.ERROR_NULL_ARGUMENT);
		if (color.isDisposed()) SWT.error(SWT.ERROR_INVALID_ARGUMENT);
		GlowFilter filter = (GlowFilter)object;
		filter.color = color.handle;
	}

	public void setSize(double size) {
		checkEffect();
		GlowFilter filter = (GlowFilter)object;
		filter.blurX = size;
		filter.blurY = size;
	}
	
	public void setAlpha(double alpha) {
		checkEffect();
		GlowFilter filter = (GlowFilter)object;
		filter.alpha = alpha;
	}
}
